﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.QuerySvcService;
using Mdws2ORM.Core;
using Mdws2ORM.Exceptions;
using BMS.Utils;
using BMS.VistaIntegration.Data;

namespace Mdws2ORM.DdrQueries.Commands
{
    public static class DdrGetsEntryCommand
    {
        public static Entry? Execute(QuerySvcSoap client, QueryParam queryParam, GetParam getParam, VistASite vistaSite, string iens)
        {            
            if (iens[iens.Length - 1] != ',')
                iens += ",";

            int i = 0;
            TextArray rpcResult = new TextArray();
            while (i < 4)
            {
                i++;
                try
                {
                    rpcResult = client.ddrGetsEntry(
                    queryParam.File,
                    iens,
                    queryParam.FieldParam,
                    getParam.Flags);
                }
                catch (Exception e)
                {
                    if (i == 4)
                    {
                        Tracer.TraceMessage(vistaSite.Name + " - Get Iteration " + i + " exception. File: " + queryParam.File);
                        Tracer.TraceException(e);
                        throw;
                    }
                    else
                    {
                        System.Threading.Thread.Sleep(5000);
                        continue;
                    }
                }
                if (rpcResult.fault == null)
                    return ProcessLines(queryParam, iens, rpcResult.text);
                else
                {
                    if (i == 4)
                    {
                        Tracer.TraceMessage(vistaSite.Name + " - Get Iteration " + i + " Mdws fault. File: " + queryParam.File);
                        QueryFaultException ex = new QueryFaultException(rpcResult.fault);
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                    else
                        Utils.IsAlive(client, vistaSite);
                }
            }
            return ProcessLines(queryParam, iens, rpcResult.text);
        }

        private static Entry? ProcessLines(QueryParam queryParam, string iens, string[] lines)
        {
            if (lines.Length == 0) return null;
            // special case for word processing order text field
            if (queryParam.File.Equals("100.008"))
                return ProcessLinesForOrderText(queryParam, iens, lines);
            else
            {
                Entry.Field[] fields = new Entry.Field[queryParam.Fields.Length];
                bool emptyValues = true;
                string ien = string.Empty, ienField = null, value = null;
                for (int i = 0, j = 0; i < lines.Length; i++)
                {
                    if (!lines[i].Contains("^"))
                        continue;
                    string[] values = lines[i].Split('^');

                    //a word processing field has multiple lines and one of them has by accident a caret
                    if (values.Length < 4)
                        continue;

                    ien = values[1];
                    ienField = values[2];
                    value = values[3];

                    if (ienField != queryParam.Fields[j])
                        throw new DataException(string.Format("Invalid input. Field ien {0} expected, but found {1}", queryParam.Fields[j], ienField));
                    if (emptyValues && value != string.Empty)
                        emptyValues = false;
                    fields[j] = new Entry.Field(queryParam.Fields[j], value);
                    j++;
                }
                if (emptyValues) return null;
                Entry entry = new Entry(queryParam.File, ien, fields);
                return entry;
            }
        }

        private static Entry? ProcessLinesForOrderText(QueryParam queryParam, string iens, string[] lines)
        {
            const string data = "[Data]";
            const string wordProcessing = "[WORD PROCESSING]";
            const string end = "$$END$$";
            if (lines.Length == 0) return null;
            bool emptyValues = true;
            string ien = string.Empty, value = null;
            ien = GetIenEntity(iens);
            StringBuilder sb = new StringBuilder();
            for (int i = 0, j = 0; i < lines.Length; i++)
            {
                if (lines[i].Contains("^"))
                {
                    string[] values = lines[i].Split('^');
                    if (values.Length == 4)
                        value = values[3];
                    else
                        value = lines[i];
                }
                else
                    value = lines[i];

                if (emptyValues && value != string.Empty)
                    emptyValues = false;
                if (!string.IsNullOrEmpty(value) && !value.Equals(data) && !value.Equals(wordProcessing) && !value.Equals(end))
                    sb.AppendLine(value);
                j++;
            }
            if (emptyValues) return null;
            Entry entry = new Entry(queryParam.File, ien, new Entry.Field[] { new Entry.Field(queryParam.FieldParam, sb.ToString()) });
            return entry;
        }

        private static string GetIenEntity(string iens)
        {
            int index = iens.IndexOf(',');
            return index > 0 ?
                iens.Substring(0, index) :
                iens;
        }
    }
}
